// This shader produces an idealised rendition of a flapping
// flag.  It is not very realistic as the flapping motion is
// is too regular and the edges stay parallel,  but is quite
// adequate for symbolic flags, e.g. for animated icons. For
// use in VGHD scenes the .scn file should provide the image
// to be used for the flag and its position in the area that
// it is being rendered in as fractions of that area's width
// and height.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

uniform vec2 flag_position; // Fractions of width and height
uniform sampler2D Flag;     // The image to use as the flag

void main ( void )
 {
   // Rescale the pixel's coordinates to be fractions of
   // the current window's dimensions.  Also  flip the Y
   // coordinate so that the image will be upright.
   
   vec2 uv = gl_FragCoord.xy / u_WindowSize;
   uv.y = 1.0 - uv.y;

   // Adjust for the required flag position  and  rescale
   // to provide space for the flag's droop and flapping.

   uv = uv - flag_position;
   uv = 1.5 * uv;

   // Apply droop and the flapping motion.  Actually this
   // is the inverse transform from the drooped  flapping
   // coordintes to the coordinates of the image.

	uv.y += sin(-u_Elapsed*5.0 + uv.x*uv.x*10.0)*0.2*uv.x - uv.x*0.3;
	uv.x += uv.y*0.05;

   // Discard if uv would be outside of the flag image.

   if ( uv.x < 0.0 || uv.y < 0.0 ) discard;
   if ( uv.x > 1.0 || uv.y > 1.0 ) discard;

   // Sample the flag image.

   gl_FragColor = vec4 ( texture2D(Flag,uv) );

 }